'
' QPack Start Menu Icon Installation Script.
' 
' If you are one of the pathetic persons that insists
' on doing everything in ASM... do this in ASM and send
' it to me, and I'll include it.
'
' Copyright (c) 1998 Qapla.
'

Set colArgs = WScript.Arguments

' Support calls from inside QPack.

if colArgs.Count = 0 then AddDefault

if colArgs.Count = 1 then AddOther

WScript.Echo "Parameter error. Parameter one should be a SHSpecialFolder object."
WScript.Quit

Sub AddDefault
  Dim intDoIt

  intDoIt =  MsgBox("This script will install an icon for Qapla's Quick Packer on your start menu. Continue?", vbOKCancel + vbInformation, "Qapla's Quick Packer Script")
  If intDoIt = vbCancel Then WScript.Quit
  AddShortcut("Programs")
  WScript.Echo "A shortcut to Qapla's Quick Packer has been installed on the start menu."
  WScript.Quit
End Sub

Sub AddOther
  AddShortcut(colArgs(0))
  WScript.Echo "A shortcut to Qapla's Quick Packer has been installed."
  WScript.Quit
End Sub

Sub AddShortcut(targetFolder)

  Dim WSHShell
  Set WSHShell = WScript.CreateObject("WScript.Shell")

  Dim MyShortcut, MyDesktop, ProgramsPath, fso

  ' Read startmenu/programs path using WshSpecialFolders object

  ProgramsPath = WSHShell.SpecialFolders(targetFolder)

  Set fso = CreateObject("Scripting.FileSystemObject")

  ' Create a shortcut object on the desktop

  Set MyShortcut = WSHShell.CreateShortcut(ProgramsPath & "\Qapla's Quick Packer.lnk")

  ' Set shortcut object properties and save it
  MyShortcut.TargetPath = fso.GetAbsolutePathName("qpack.exe")
  MyShortcut.WorkingDirectory = fso.GetAbsolutePathName(".")
  MyShortcut.WindowStyle = 4
  MyShortcut.IconLocation = fso.GetAbsolutePathName("qpack.exe") & ", 0"
  MyShortcut.Save

End Sub

